	// Funzione pulsante "dati del tempo" 
	
	 function uranus_tab_alma(obj)
	{  
		// Firma digitale 
		if (obj.FIRMA.value == "     Agostino Frosini  -  Javascript Software 2020  -") 
			{
				// Dichiarazioni delle variabili 	
				giorno = myParseFloat(obj.giorno.value);
				if (giorno >31 | giorno <= 0)
					{
						alert("\n GIORNO ERRATO: \n\n DATI VALIDI DA 1 A 31 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				mese = myParseFloat(obj.mese.value);
				if (mese >12 | mese <= 0)
					{
						alert("\n MESE ERRATO: \n\n DATI VALIDI DA 1 A 12 \n\n CLICCA SU RESET E RIPROVA");  
					}
				anno = myParseFloat(obj.anno.value);
				

				ore = myParseFloat(obj.ore.value); 
				if (ore >=24 | ore < 0)
					{
						alert("\n ORE ERRATE: \n\n DATI VALIDI DA 0 A 23 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				minuti = myParseFloat(obj.minuti.value); 
				if (minuti >=60 | minuti < 0)
					{
						alert("\n MINUTI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				secondi = myParseFloat(obj.secondi.value); 
				if (secondi >=60 | secondi < 0)
					{
						alert("\n SECONDI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
					}		
				lat_G = myParseFloat(obj.lat_G.value); 
				if (lat_G >= 90 | lat_G <= -90)
					{
						alert("\n GRADI LATITUDINE ERRATI: \n\n DATI VALIDI DA -89 A +89 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				lat_M = myParseFloat(obj.lat_M.value); 
				if (lat_M >= 60 | lat_M <= -60)
					{
						alert("\n PRIMI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				lat_S = myParseFloat(obj.lat_S.value);
				if (lat_S >= 60 | lat_S <= -60)
					{
						alert("\n SECONDI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_G = myParseFloat(obj.long_G.value); 
				if (long_G >= 180 | long_G <= -180)
					{
						alert("\n GRADI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -179 A +179 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_M = myParseFloat(obj.long_M.value); 
				if (long_M >= 60 | long_M <= -60)
					{
						alert("\n PRIMI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}
				long_S = myParseFloat(obj.long_S.value); 
				if (long_S >= 60 | long_S <= -60)
					{
						alert("\n SECONDI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
					}

				pressione = myParseFloat(obj.PRESSIONE.value); 
				if (pressione >=1300 | pressione <= 300)
					{
						alert("\n DATO PRESSIONE INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
					}	
			

				temperatura = myParseFloat(obj.TEMPERATURA.value); 
				if (temperatura >=100 | temperatura <= -50)
					{
						alert("\n DATO TEMPERATURA INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
					}	
			
				metri = myParseFloat(obj.METRI.value); 	

				fuso = myParseFloat(obj.FUSO_ORARIO.value); 	

	
				// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
				if (obj.giorno.value < 10) obj.giorno.value = "0"+obj.giorno.value;
				if (obj.mese.value < 10) obj.mese.value = "0"+obj.mese.value;
		
				// Unisce anno mese giorno in una stringa 
				s = (obj.anno.value+obj.mese.value+obj.giorno.value);
		
				// La stringa data unita ritorna numero 
				s = parseInt(s);  	
			    
				
				// Calcolo dei giorni e ore decimali
				giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
				giorno_dec_et = ((secondi + et()[4])/ 3600 + minuti / 60 + ore)/24 + giorno;
				
				ore_dec = secondi / 3600 + minuti /60 + ore;
	
	
				// Conversione latitudine in gradi decimali 	
				lat_dec = lat_S / 3600 + lat_M / 60 + lat_G;
					
				// Conversione longitudine in gradi decimali
				long_dec = long_S / 3600 + long_M /60 + long_G;
		
				// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
				// Creazione variabile JD_0  
				JD_0 = jd_ore_0();
				
				// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
				// Creazione variabile JD_UT   
				JD_UT = jd_ore_ut(); 
				
				JD_ET = jd_ore_et(); 
	
				// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
				obj.giorno.value = giorno; 
				
				// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
				obj.mese.value = mese;
	
				
			
// -------------------------- INIZIO PROGRAMMA CHE CALCOLA IL SORGERE ED IL TRAMONTO DEGLI ASTRI ----------------------------------------
			
// ----------------- ESTRAZIONE DAL DATA BASE DEI VALORI DI AR E DEC PER IL GIORNO PRIMA, IL GIORNO IN CORSO ED IL GIORNO DOPO ----------

	
	
// -----------------------------CALCOLO AR DEC DEL GIORNO PRIMA A ORE O (JD_0 - 1) ------------------------------------------------------
				
			// variabili per la trasformazione di gradi e radianti 
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
			
			// secoli 
			var T = ((JD_0 - 1) - 2451545.0)/36525;
			
			// millenni 
			var ro = ((JD_0 - 1) - 2451545.0)/365250;	
			
			var L = uranus_vsop87(ro)[0];
			var B = uranus_vsop87(ro)[1];
			var R = uranus_vsop87(ro)[2];
			var L_E = uranus_vsop87(ro)[3];
			var B_E = uranus_vsop87(ro)[4];
			var R_E = uranus_vsop87(ro)[5];
			
			var long_ecl_real_0 = L ;
			var lat_ecl_real_0 = B ; 

			var x0 = R * Math.cos(B*r) * Math.cos(L*r) - R_E * Math.cos(B_E*r) * Math.cos(L_E*r); 
			var y0 = R * Math.cos(B*r) * Math.sin(L*r) - R_E * Math.cos(B_E*r) * Math.sin(L_E*r); 
			var z0 = R * Math.sin(B*r) - R_E * Math.sin(B_E*r); 

			var delta0 = Math.sqrt(Math.pow(x0,2) + Math.pow(y0,2) + Math.pow(z0,2)); 
			
			var delta0_GM = delta0 * 149597870.691 / 1000000;

			var t0 = 0.0057755183 * delta0;
			
			var ro1 = (((JD_0 - 1) - t0) - 2451545.0)/365250;


// ----------------------------Cambio ro per effetto del tempo luce --------------------------------


			var L_TL = uranus_TL_vsop87(ro1)[0];
			var B_TL = uranus_TL_vsop87(ro1)[1];
			var R_TL = uranus_TL_vsop87(ro1)[2];
			var L_E_TL = uranus_TL_vsop87(ro1)[3];
			var B_E_TL = uranus_TL_vsop87(ro1)[4];
			var R_E_TL = uranus_TL_vsop87(ro1)[5];
			
		
			var R_TL_GM = R_TL * 149597870.691 / 1000000;


			var x1 = R_TL * Math.cos(B_TL*r) * Math.cos(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.cos(L_E_TL*r); 
			var y1 = R_TL * Math.cos(B_TL*r) * Math.sin(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.sin(L_E_TL*r); 
			var z1 = R_TL * Math.sin(B_TL*r) - R_E_TL * Math.sin(B_E_TL*r); 
						

			var delta1 = Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2) + Math.pow(z1,2)); 
			
			var delta1_GM = delta1 * 149597870.691 / 1000000;

			var t1 = 0.0057755183 * delta1;

			var long_ecl_0 = Math.atan2(y1,x1)*r1;
			if(long_ecl_0<0){long_ecl_0=long_ecl_0+360}

			var lat_ecl_0 = Math.atan2(z1,Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2)))*r1;

			var fk5_L1 = long_ecl_0 - 1.397 * T - 0.00031 * Math.pow(T,2); 
			
			var fk5_DL = -0.09033 + 0.03916 * (Math.cos(fk5_L1*r) + Math.sin(fk5_L1*r)) * Math.tan(lat_ecl_0*r); 
			var fk5_DB = 0.03916 * (Math.cos(fk5_L1*r) - Math.sin(fk5_L1*r)); 
	
	
			var long_ecl_1 = long_ecl_0 + fk5_DL / 3600 ; 
			var lat_ecl_1 = lat_ecl_0 + fk5_DB  / 3600 ;
	
			var nut_DL = nut_ut_0()[6]/3600; 
	
			var long_ecl_2 = long_ecl_1 + nut_DL ; 
			var lat_ecl_2 = lat_ecl_1  ;
			
			var E1 = nut_ut_0()[8]; 
	
			var ar = Math.atan2(Math.sin(long_ecl_2*r)*Math.cos(E1*r)-Math.tan(lat_ecl_2*r)*Math.sin(E1*r),Math.cos(long_ecl_2*r))*r1;
			if(ar<0){ar=ar+360}
			var ar_h = ar / 15;
			
			var dec = Math.asin(Math.sin(lat_ecl_2*r)*Math.cos(E1*r)+Math.cos(lat_ecl_2*r)*Math.sin(E1*r)*Math.sin(long_ecl_2*r))*r1;
	
			
			var alma_ar_1 = ar;
			var alma_dec_1 = dec;



//  ------------------------  CALCOLO AR DEC DEL GIORNO ATTUALE A ORE O (JD_0) -----------------------------------

			// variabili per la trasformazione di gradi e radianti 
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
			
			// secoli 
			var T = (JD_0  - 2451545.0)/36525;
			
			// millenni 
			var ro = (JD_0  - 2451545.0)/365250;	
			
			var L = uranus_vsop87(ro)[0];
			var B = uranus_vsop87(ro)[1];
			var R = uranus_vsop87(ro)[2];
			var L_E = uranus_vsop87(ro)[3];
			var B_E = uranus_vsop87(ro)[4];
			var R_E = uranus_vsop87(ro)[5];
			
			
			var long_ecl_real_0 = L ;
			var lat_ecl_real_0 = B ; 


			var x0 = R * Math.cos(B*r) * Math.cos(L*r) - R_E * Math.cos(B_E*r) * Math.cos(L_E*r); 
			var y0 = R * Math.cos(B*r) * Math.sin(L*r) - R_E * Math.cos(B_E*r) * Math.sin(L_E*r); 
			var z0 = R * Math.sin(B*r) - R_E * Math.sin(B_E*r); 

			var delta0 = Math.sqrt(Math.pow(x0,2) + Math.pow(y0,2) + Math.pow(z0,2)); 
			
			var delta0_GM = delta0 * 149597870.691 / 1000000;

			var t0 = 0.0057755183 * delta0;
			
			
			var ro1 = ((JD_0  - t0) - 2451545.0)/365250;


// ----------------------------Cambio ro per effetto del tempo luce --------------------------------


			var L_TL = uranus_TL_vsop87(ro1)[0];
			var B_TL = uranus_TL_vsop87(ro1)[1];
			var R_TL = uranus_TL_vsop87(ro1)[2];
			var L_E_TL = uranus_TL_vsop87(ro1)[3];
			var B_E_TL = uranus_TL_vsop87(ro1)[4];
			var R_E_TL = uranus_TL_vsop87(ro1)[5];
			
		
			var R_TL_GM = R_TL * 149597870.691 / 1000000;


			var x1 = R_TL * Math.cos(B_TL*r) * Math.cos(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.cos(L_E_TL*r); 
			var y1 = R_TL * Math.cos(B_TL*r) * Math.sin(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.sin(L_E_TL*r); 
			var z1 = R_TL * Math.sin(B_TL*r) - R_E_TL * Math.sin(B_E_TL*r); 
						

			var delta1 = Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2) + Math.pow(z1,2)); 
			
			var delta1_GM = delta1 * 149597870.691 / 1000000;

			var t1 = 0.0057755183 * delta1;

			var long_ecl_0 = Math.atan2(y1,x1)*r1;
			if(long_ecl_0<0){long_ecl_0=long_ecl_0+360}

			var lat_ecl_0 = Math.atan2(z1,Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2)))*r1;

			var fk5_L1 = long_ecl_0 - 1.397 * T - 0.00031 * Math.pow(T,2); 
			
			var fk5_DL = -0.09033 + 0.03916 * (Math.cos(fk5_L1*r) + Math.sin(fk5_L1*r)) * Math.tan(lat_ecl_0*r); 
			var fk5_DB = 0.03916 * (Math.cos(fk5_L1*r) - Math.sin(fk5_L1*r)); 
	
	
			var long_ecl_1 = long_ecl_0 + fk5_DL / 3600 ; 
			var lat_ecl_1 = lat_ecl_0 + fk5_DB  / 3600 ;
	
			var nut_DL = nut_ut_0()[6]/3600; 
	
			var long_ecl_2 = long_ecl_1 + nut_DL ; 
			var lat_ecl_2 = lat_ecl_1  ;
			
			var E1 = nut_ut_0()[8]; 
	
			var ar = Math.atan2(Math.sin(long_ecl_2*r)*Math.cos(E1*r)-Math.tan(lat_ecl_2*r)*Math.sin(E1*r),Math.cos(long_ecl_2*r))*r1;
			if(ar<0){ar=ar+360}
			var ar_h = ar / 15;
			
			var dec = Math.asin(Math.sin(lat_ecl_2*r)*Math.cos(E1*r)+Math.cos(lat_ecl_2*r)*Math.sin(E1*r)*Math.sin(long_ecl_2*r))*r1;
	
			
			var alma_ar_2 = ar ;
			var alma_dec_2 = dec ;
			
 
//  ------------------------------------ CALCOLO AR DEC DEL GIORNO DOPO A ORE O (JD_0 + 1) ------------------------------------------------

			// variabili per la trasformazione di gradi e radianti 
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
			
			// secoli 
			var T = ((JD_0 + 1) - 2451545.0)/36525;
			
			// millenni 
			var ro = ((JD_0 + 1) - 2451545.0)/365250;	
			
			var L = uranus_vsop87(ro)[0];
			var B = uranus_vsop87(ro)[1];
			var R = uranus_vsop87(ro)[2];
			var L_E = uranus_vsop87(ro)[3];
			var B_E = uranus_vsop87(ro)[4];
			var R_E = uranus_vsop87(ro)[5];
			
			
			var long_ecl_real_0 = L ;
			var lat_ecl_real_0 = B ; 


			var x0 = R * Math.cos(B*r) * Math.cos(L*r) - R_E * Math.cos(B_E*r) * Math.cos(L_E*r); 
			var y0 = R * Math.cos(B*r) * Math.sin(L*r) - R_E * Math.cos(B_E*r) * Math.sin(L_E*r); 
			var z0 = R * Math.sin(B*r) - R_E * Math.sin(B_E*r); 

			var delta0 = Math.sqrt(Math.pow(x0,2) + Math.pow(y0,2) + Math.pow(z0,2)); 
			
			var delta0_GM = delta0 * 149597870.691 / 1000000;

			var t0 = 0.0057755183 * delta0;
			
			
			var ro1 = (((JD_0 + 1) - t0) - 2451545.0)/365250;


// ----------------------------Cambio ro per effetto del tempo luce --------------------------------


			var L_TL = uranus_TL_vsop87(ro1)[0];
			var B_TL = uranus_TL_vsop87(ro1)[1];
			var R_TL = uranus_TL_vsop87(ro1)[2];
			var L_E_TL = uranus_TL_vsop87(ro1)[3];
			var B_E_TL = uranus_TL_vsop87(ro1)[4];
			var R_E_TL = uranus_TL_vsop87(ro1)[5];
			
		
			var R_TL_GM = R_TL * 149597870.691 / 1000000;


			var x1 = R_TL * Math.cos(B_TL*r) * Math.cos(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.cos(L_E_TL*r); 
			var y1 = R_TL * Math.cos(B_TL*r) * Math.sin(L_TL*r) - R_E_TL * Math.cos(B_E_TL*r) * Math.sin(L_E_TL*r); 
			var z1 = R_TL * Math.sin(B_TL*r) - R_E_TL * Math.sin(B_E_TL*r); 
						

			var delta1 = Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2) + Math.pow(z1,2)); 
			
			var delta1_GM = delta1 * 149597870.691 / 1000000;

			var t1 = 0.0057755183 * delta1;

			var long_ecl_0 = Math.atan2(y1,x1)*r1;
			if(long_ecl_0<0){long_ecl_0=long_ecl_0+360}

			var lat_ecl_0 = Math.atan2(z1,Math.sqrt(Math.pow(x1,2) + Math.pow(y1,2)))*r1;

			var fk5_L1 = long_ecl_0 - 1.397 * T - 0.00031 * Math.pow(T,2); 
			
			var fk5_DL = -0.09033 + 0.03916 * (Math.cos(fk5_L1*r) + Math.sin(fk5_L1*r)) * Math.tan(lat_ecl_0*r); 
			var fk5_DB = 0.03916 * (Math.cos(fk5_L1*r) - Math.sin(fk5_L1*r)); 
	
	
			var long_ecl_1 = long_ecl_0 + fk5_DL / 3600 ; 
			var lat_ecl_1 = lat_ecl_0 + fk5_DB  / 3600 ;
	
			var nut_DL = nut_ut_0()[6]/3600; 
	
			var long_ecl_2 = long_ecl_1 + nut_DL ; 
			var lat_ecl_2 = lat_ecl_1  ;
			
			var E1 = nut_ut_0()[8]; 
	
			var ar = Math.atan2(Math.sin(long_ecl_2*r)*Math.cos(E1*r)-Math.tan(lat_ecl_2*r)*Math.sin(E1*r),Math.cos(long_ecl_2*r))*r1;
			if(ar<0){ar=ar+360}
			var ar_h = ar / 15;
			
			var dec = Math.asin(Math.sin(lat_ecl_2*r)*Math.cos(E1*r)+Math.cos(lat_ecl_2*r)*Math.sin(E1*r)*Math.sin(long_ecl_2*r))*r1;
			
			var alma_ar_3 = ar;
			var alma_dec_3 = dec;


// ---------------------------- INIZIO DELLE FORMULE PER IL CALCOLO DEL SORGERE MERIDIANO E TRAMONTO ASTRONOMICO ------------------------

			// FATTORI PER LA TRASFORMAZIONE COORDINATE RADIANTI
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
 			
			// Conversione latitudine in gradi decimali 	
			var lat_dec = lat_S / 3600 + lat_M / 60 + lat_G;
				
			// Conversione longitudine in gradi decimali
			var long_dec = long_S / 3600 + long_M /60 + long_G;

			// trasformazione longitudine in negativo per calcolare l'angolo orario 
			long_dec = long_dec * - 1;
 			
			// ALTEZZA GEOMETRICA PER STELLE E PIANETI
			var alma_h0 = 0;
			
			// DELTA T 
			var alma_dt = et()[4];

			// GIORNI GIULIANI 
			var alma_jd_1 = JD_0 - 1 ; 
			var alma_jd_2 = JD_0; 
			var alma_jd_3 = JD_0 + 1 ; 
			
			// TEMPO SIDEREO AD ORE 0 
			var alma_TS_0 = (ts_ut_c_0()[2] / 3600 + ts_ut_c_0()[1] / 60 + ts_ut_c_0()[0]) * 15;
						
 
			/*
			// valori di prova ---------------------------------
			alma_ar_1 = 40.68021
			alma_dec_1 = 18.04761 
			alma_ar_2 = 41.73129
			alma_dec_2 = 18.44092
			alma_ar_3 = 42.78204
			alma_dec_3 = 18.82742
			lat_dec = 42.3333
			long_dec = 71.0833
			// valori di prova ---------------------------------
			*/
 
			// SECONDO MEMBRO FORMULA ANGOLO ORARIO GIORNO IN CORSO PER IL TEST CIRCUMPOLARE
			var alma_H0 = (Math.sin(alma_h0*r) - Math.sin(lat_dec*r) * Math.sin(alma_dec_2*r)) / (Math.cos(lat_dec*r) * Math.cos(alma_dec_2*r));


			if (alma_H0>+1 || alma_H0<-1)
			{ 
 			var sorgere = "astro" + '\n' + "circumpolare";     
			var meridiano = "astro" + '\n' + "circumpolare";   
			var tramonto = "astro" + '\n' + "circumpolare";  
 			}
			else 
			{

			// ANGOLO ORARIO GIORNO IN CORSO 
			alma_H0 = Math.acos(alma_H0)*r1;

			// FRAZIONI DI TEMPO DA MOLTIPLICARE A 24 PER AVERE DEGLI ORARI APPROSSIMATI DI MERIDIANO,SORGERE E TRAMONTO
			var alma_m0 =  (alma_ar_2 + long_dec - alma_TS_0) / 360; 
			if(alma_m0 < 0){alma_m0 = alma_m0 + 1 }
			if(alma_m0 > 1){alma_m0 = alma_m0 - 1 }

			var alma_m1 = alma_m0 - alma_H0 / 360;
			if(alma_m1 < 0){alma_m1 = alma_m1 + 1 }
			if(alma_m1 > 1){alma_m1 = alma_m1 - 1 }

			var alma_m2 = alma_m0 + alma_H0 / 360;
			if(alma_m2 < 0){alma_m2 = alma_m2 + 1 }
			if(alma_m2 > 1){alma_m2 = alma_m2 - 1 }

			// CALCOLO TEMPO SIDEREO  MERIDIANO,SORGERE E TRAMONTO
			var alma_ts_0 = alma_TS_0 + 360.985647 * alma_m0;  
			if(alma_ts_0 > 360){alma_ts_0 = alma_ts_0 - 360}
			var alma_ts_1 = alma_TS_0 + 360.985647 * alma_m1;  
			if(alma_ts_1 > 360){alma_ts_1 = alma_ts_1 - 360}
			var alma_ts_2 = alma_TS_0 + 360.985647 * alma_m2;  
			if(alma_ts_2 > 360){alma_ts_2 = alma_ts_2 - 360}

			// CALCOLO DEL FATTORE DI INTERPOLAZIONE (n) PER IL MERIDIANO, SORGERE E TRAMONTO 
			var alma_n0 = alma_m0 + alma_dt / 86400; 
			var alma_n1 = alma_m1 + alma_dt / 86400; 
			var alma_n2 = alma_m2 + alma_dt / 86400; 
			
			// INTERPOLAZIONE DI ASCENSIONE RETTA PER IL MERIDIANO, SORGERE E TRAMONTO 

			// CONDIZIONI CHE SERVONO PER FARE IN MODO CHE LE AR DEI GIORNI DOPO SIANO SEMPRE SUPERIORI AI GIORNI PRECEDENTI 
			// IN QUESTO CASO QUESTE CONDIZIONI NON SI POSSONO METTERE PERCHE' A VOLTE IL SISTEMA NON FUNZIONA, VEDI MIRACH 8/11/2016
			// TROVATA LA SOLUZIONE AUMENTANDO DI 180 IL VALORE DA CONFRONTARE 
			// -------------------------------------------------------------------------------------------------------------
			if (alma_ar_2 + 180 < alma_ar_1){alma_ar_2 = alma_ar_2 + 360}
			if (alma_ar_3 + 180 < alma_ar_2){alma_ar_3 = alma_ar_3 + 360}
			// -------------------------------------------------------------------------------------------------------------
			var alma_ar_a = alma_ar_2 - alma_ar_1; 
			var alma_ar_b = alma_ar_3 - alma_ar_2; 
			var alma_ar_c = alma_ar_b - alma_ar_a; 
			
			var alma_ar_int0 = alma_ar_2 + alma_n0 / 2 * (alma_ar_a + alma_ar_b + alma_n0 * alma_ar_c);
			var alma_ar_int1 = alma_ar_2 + alma_n1 / 2 * (alma_ar_a + alma_ar_b + alma_n1 * alma_ar_c);
			var alma_ar_int2 = alma_ar_2 + alma_n2 / 2 * (alma_ar_a + alma_ar_b + alma_n2 * alma_ar_c);
			
			// INTERPOLAZIONE DI DECLINAZIONE PER IL SORGERE E TRAMONTO 
			var alma_dec_a = alma_dec_2 - alma_dec_1; 
			var alma_dec_b = alma_dec_3 - alma_dec_2; 
			var alma_dec_c = alma_dec_b - alma_dec_a; 
			
			var alma_dec_int1 = alma_dec_2 + alma_n1 / 2 * (alma_dec_a + alma_dec_b + alma_n1 * alma_dec_c);
			var alma_dec_int2 = alma_dec_2 + alma_n2 / 2 * (alma_dec_a + alma_dec_b + alma_n2 * alma_dec_c);
			
			// CALCOLO ANGOLO ORARIO DEL MERIDIANO, SORGERE E TRAMONTO 
			var alma_Hour0 = alma_ts_0 - long_dec - alma_ar_int0; 
			var alma_Hour1 = alma_ts_1 - long_dec - alma_ar_int1; 
			var alma_Hour2 = alma_ts_2 - long_dec - alma_ar_int2; 
			
			// CALCOLO ALTEZZA DEL SORGERE 
			var alma_h1 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int1*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int1*Math.PI/180)*Math.cos(alma_Hour1*Math.PI/180))*180/Math.PI;	
			// CALCOLO ALTEZZA DEL TRAMONTO 
			var alma_h2 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int2*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int2*Math.PI/180)*Math.cos(alma_Hour2*Math.PI/180))*180/Math.PI;	
			
			// CALCOLO DELTA (m) MERIDIANO, SORGERE E TRAMONTO 
			var alma_delta0 = - alma_Hour0 / 360;
			var alma_delta1 = (alma_h1 - alma_h0) / (360 * Math.cos(alma_dec_int1*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour1*r));
			var alma_delta2 = (alma_h2 - alma_h0) / (360 * Math.cos(alma_dec_int2*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour2*r));

 			// AGGIUNTA AI VALORI DI (m) I RELATIVI DELTA (m) PER IL MERIDIANO, SORGERE E TRAMONTO E RELATIVA CONVERSIONE IL 24 ESIMI 
			var alma_sorgere = (alma_m1 + alma_delta1) * 24; 
			var alma_meridiano = (alma_m0 + alma_delta0) * 24;
			var alma_tramonto = (alma_m2 + alma_delta2) * 24; 
			
			// CONDIZIONI CHE SERVONO QUANDO L'ORARIO E' NEGATIVO OPPURE OLTRE LA 24 ESIMA ORA 
			// -------------------------------------------------------------------------------
			// SORGERE  			
			if(alma_sorgere < 0){alma_sorgere = alma_sorgere + 24}
			if(alma_sorgere >= 24 ){alma_sorgere = alma_sorgere - 24}
			
			// MERIDIANO 
			if(alma_meridiano < 0){alma_meridiano = alma_meridiano + 24}
			if(alma_meridiano >= 24 ){alma_meridiano = alma_meridiano - 24}
			
			// TRAMONTO
			if(alma_tramonto < 0){alma_tramonto = alma_tramonto + 24}
			if(alma_tramonto >= 24 ){alma_tramonto = alma_tramonto - 24}
			// --------------------------------------------------------------------------------

			// CONVERSIONE DEI TEMPI IN ORE E RISULTATI FINALI IN LINEA 
 			var sorgere_H = Math.floor(alma_sorgere); 
			var sorgere_M_dec = (alma_sorgere - sorgere_H) * 60; 
			var sorgere_M = Math.floor(sorgere_M_dec); 
			var sorgere_S = (sorgere_M_dec - sorgere_M) * 60; 
			
//			var sorgere_cambio_data = "stesso giorno"; 
			var sorgere_HL = sorgere_H + fuso;
			if(sorgere_HL < 0) {sorgere_HL = sorgere_HL + 24} 
			if(sorgere_HL >= 24) {sorgere_HL = sorgere_HL - 24 }

			var sorgere = "Tempo Universale" + '\n' + myParseFloat_null((sorgere_H)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2))  + '\n' + '\n' + "Tempo Civile" + '\n' + myParseFloat_null((sorgere_HL)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2));

			// SOLUZIONE FINALE SOLO TEMPO CIVILE  
			var sorgere_tc = myParseFloat_null((sorgere_HL)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2));

 			var meridiano_H = Math.floor(alma_meridiano); 
			var meridiano_M_dec = (alma_meridiano - meridiano_H) * 60; 
			var meridiano_M = Math.floor(meridiano_M_dec); 
			var meridiano_S = (meridiano_M_dec - meridiano_M) * 60; 
			
//			var meridiano_cambio_data = "stesso giorno"; 
			var meridiano_HL = meridiano_H + fuso;
			if(meridiano_HL < 0) {meridiano_HL = meridiano_HL + 24}
  			if(meridiano_HL >= 24) {meridiano_HL = meridiano_HL - 24 }

			var meridiano = "Tempo Universale" + '\n' + myParseFloat_null((meridiano_H))  + " : " + myParseFloat_null(meridiano_M) + " : " + myParseFloat_null(meridiano_S.toFixed(2))+ '\n' + '\n' +"Tempo Civile" + '\n' + myParseFloat_null((meridiano_HL)) + " : " + myParseFloat_null(meridiano_M) + " : " + myParseFloat_null(meridiano_S.toFixed(2));
			
			// SOLUZIONE FINALE SOLO TEMPO CIVILE 
			var meridiano_tc = myParseFloat_null((meridiano_HL)) + " : " + myParseFloat_null(meridiano_M) + " : " + myParseFloat_null(meridiano_S.toFixed(2));

 			var tramonto_H = Math.floor(alma_tramonto); 
			var tramonto_M_dec = (alma_tramonto - tramonto_H) * 60; 
			var tramonto_M = Math.floor(tramonto_M_dec); 
			var tramonto_S = (tramonto_M_dec - tramonto_M) * 60; 
			
//			var tramonto_cambio_data = "stesso giorno"; 
			var tramonto_HL = tramonto_H + fuso;
			if(tramonto_HL < 0) {tramonto_HL = tramonto_HL + 24 }
			if(tramonto_HL >= 24) {tramonto_HL = tramonto_HL - 24 }

			var tramonto = "Tempo Universale" + '\n' + myParseFloat_null((tramonto_H)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2)) + '\n' + '\n' + "Tempo Civile" + '\n' + myParseFloat_null((tramonto_HL)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2));
			
			// SOLUZIONE FINALE SOLO TEMPO CIVILE
			var tramonto_tc = myParseFloat_null((tramonto_HL)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2));

		}



			obj.S_URANUS.value = sorgere;
			obj.M_URANUS.value = meridiano;
			obj.T_URANUS.value = tramonto;


// -------------------------------------------- FINE CALCOLO SORGERE MERIDIANO E TRAMONTO ASTRONOMICO  -----------------------------------------------------------------------------



// ---------------------------- INIZIO DELLE FORMULE PER IL CALCOLO DEL SORGERE MERIDIANO E TRAMONTO APPARENTE ------------------------

 			
			// scelta dell'opzione che proviene dal selettore nella pagina web principale 
			var scelta_rifrazione_urano = obj.RIFRAZIONE_URANO.value;
			
/*	
			if (scelta_rifrazione_stelle == 0)
				{
					// ALTEZZA GEOMETRICA PER STELLE E PIANETI (RIFRAZIONE STANDARD 34') 
				 	var alma_h0 = - 0.566666666667;
					obj.RIFDEP_URANO.value = "+ 0°34'0.00";
					
				}
*/


			if (scelta_rifrazione_urano == 0)
				{
					// ALTEZZA GEOMETRICA PER STELLE E PIANETI (RIFRAZIONE CALCOLATA CON BENNET) 
				 	var alma_h0 = - rifdep()[0];
					obj.RIFDEP_URANO.value = rifdep()[1];
				}

			if (scelta_rifrazione_urano == 1)
				{
					// ALTEZZA GEOMETRICA PER STELLE E PIANETI (DEPRESSIONE ORIZZONTE) 
				 	var alma_h0 = - rifdep()[2];
					obj.RIFDEP_URANO.value = rifdep()[3];
					
				}

			if (scelta_rifrazione_urano == 2)
				{
					// ALTEZZA GEOMETRICA PER STELLE E PIANETI (RIFRAZIONE CALCOLATA CON BENNET E DEPRESSIONE ORIZZONTE) 
					var alma_h0 = - (rifdep()[0] + rifdep()[2]);
					obj.RIFDEP_URANO.value = rifdep()[4];
				}



			// ALTEZZA GEOMETRICA PER STELLE E PIANETI (RIFRAZIONE STANDARD 34') 
			// var alma_h0 = - 0.566666666667;
			
			// DELTA T 
			var alma_dt = et()[4];

			// GIORNI GIULIANI 
			var alma_jd_1 = JD_0 - 1 ; 
			var alma_jd_2 = JD_0; 
			var alma_jd_3 = JD_0 + 1 ; 
			
			// TEMPO SIDEREO AD ORE 0 
			var alma_TS_0 = (ts_ut_c_0()[2] / 3600 + ts_ut_c_0()[1] / 60 + ts_ut_c_0()[0]) * 15;
						
 
			/*
			// valori di prova ---------------------------------
			alma_ar_1 = 40.68021
			alma_dec_1 = 18.04761 
			alma_ar_2 = 41.73129
			alma_dec_2 = 18.44092
			alma_ar_3 = 42.78204
			alma_dec_3 = 18.82742
			lat_dec = 42.3333
			long_dec = 71.0833
			// valori di prova ---------------------------------
			*/
 
			// SECONDO MEMBRO FORMULA ANGOLO ORARIO GIORNO IN CORSO PER IL TEST CIRCUMPOLARE
			var alma_H0 = (Math.sin(alma_h0*r) - Math.sin(lat_dec*r) * Math.sin(alma_dec_2*r)) / (Math.cos(lat_dec*r) * Math.cos(alma_dec_2*r));


			if (alma_H0>+1 || alma_H0<-1)
			{ 
 			var sorgere = "astro" + '\n' + "circumpolare";     
			var meridiano = "astro" + '\n' + "circumpolare";   
			var tramonto = "astro" + '\n' + "circumpolare";  
 			}
			else 
			{

			// ANGOLO ORARIO GIORNO IN CORSO 
			alma_H0 = Math.acos(alma_H0)*r1;

			// FRAZIONI DI TEMPO DA MOLTIPLICARE A 24 PER AVERE DEGLI ORARI APPROSSIMATI DI MERIDIANO,SORGERE E TRAMONTO
			var alma_m0 =  (alma_ar_2 + long_dec - alma_TS_0) / 360; 
			if(alma_m0 < 0){alma_m0 = alma_m0 + 1 }
			if(alma_m0 > 1){alma_m0 = alma_m0 - 1 }

			var alma_m1 = alma_m0 - alma_H0 / 360;
			if(alma_m1 < 0){alma_m1 = alma_m1 + 1 }
			if(alma_m1 > 1){alma_m1 = alma_m1 - 1 }

			var alma_m2 = alma_m0 + alma_H0 / 360;
			if(alma_m2 < 0){alma_m2 = alma_m2 + 1 }
			if(alma_m2 > 1){alma_m2 = alma_m2 - 1 }

			// CALCOLO TEMPO SIDEREO  MERIDIANO,SORGERE E TRAMONTO
			var alma_ts_0 = alma_TS_0 + 360.985647 * alma_m0;  
			if(alma_ts_0 > 360){alma_ts_0 = alma_ts_0 - 360}
			var alma_ts_1 = alma_TS_0 + 360.985647 * alma_m1;  
			if(alma_ts_1 > 360){alma_ts_1 = alma_ts_1 - 360}
			var alma_ts_2 = alma_TS_0 + 360.985647 * alma_m2;  
			if(alma_ts_2 > 360){alma_ts_2 = alma_ts_2 - 360}

			// CALCOLO DEL FATTORE DI INTERPOLAZIONE (n) PER IL MERIDIANO, SORGERE E TRAMONTO 
			var alma_n0 = alma_m0 + alma_dt / 86400; 
			var alma_n1 = alma_m1 + alma_dt / 86400; 
			var alma_n2 = alma_m2 + alma_dt / 86400; 
			
			// INTERPOLAZIONE DI ASCENSIONE RETTA PER IL MERIDIANO, SORGERE E TRAMONTO 

			// CONDIZIONI CHE SERVONO PER FARE IN MODO CHE LE AR DEI GIORNI DOPO SIANO SEMPRE SUPERIORI AI GIORNI PRECEDENTI 
			// IN QUESTO CASO QUESTE CONDIZIONI NON SI POSSONO METTERE PERCHE' A VOLTE IL SISTEMA NON FUNZIONA, VEDI MIRACH 8/11/2016
			// TROVATA LA SOLUZIONE AUMENTANDO DI 180 IL VALORE DA CONFRONTARE 
			// -------------------------------------------------------------------------------------------------------------
			if (alma_ar_2 + 180 < alma_ar_1){alma_ar_2 = alma_ar_2 + 360}
			if (alma_ar_3 + 180 < alma_ar_2){alma_ar_3 = alma_ar_3 + 360}
			// -------------------------------------------------------------------------------------------------------------
			var alma_ar_a = alma_ar_2 - alma_ar_1; 
			var alma_ar_b = alma_ar_3 - alma_ar_2; 
			var alma_ar_c = alma_ar_b - alma_ar_a; 
			
			var alma_ar_int0 = alma_ar_2 + alma_n0 / 2 * (alma_ar_a + alma_ar_b + alma_n0 * alma_ar_c);
			var alma_ar_int1 = alma_ar_2 + alma_n1 / 2 * (alma_ar_a + alma_ar_b + alma_n1 * alma_ar_c);
			var alma_ar_int2 = alma_ar_2 + alma_n2 / 2 * (alma_ar_a + alma_ar_b + alma_n2 * alma_ar_c);
			
			// INTERPOLAZIONE DI DECLINAZIONE PER IL SORGERE E TRAMONTO 
			var alma_dec_a = alma_dec_2 - alma_dec_1; 
			var alma_dec_b = alma_dec_3 - alma_dec_2; 
			var alma_dec_c = alma_dec_b - alma_dec_a; 
			
			var alma_dec_int1 = alma_dec_2 + alma_n1 / 2 * (alma_dec_a + alma_dec_b + alma_n1 * alma_dec_c);
			var alma_dec_int2 = alma_dec_2 + alma_n2 / 2 * (alma_dec_a + alma_dec_b + alma_n2 * alma_dec_c);
			
			// CALCOLO ANGOLO ORARIO DEL MERIDIANO, SORGERE E TRAMONTO 
			var alma_Hour0 = alma_ts_0 - long_dec - alma_ar_int0; 
			var alma_Hour1 = alma_ts_1 - long_dec - alma_ar_int1; 
			var alma_Hour2 = alma_ts_2 - long_dec - alma_ar_int2; 
			
			// CALCOLO ALTEZZA DEL SORGERE 
			var alma_h1 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int1*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int1*Math.PI/180)*Math.cos(alma_Hour1*Math.PI/180))*180/Math.PI;	
			// CALCOLO ALTEZZA DEL TRAMONTO 
			var alma_h2 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int2*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int2*Math.PI/180)*Math.cos(alma_Hour2*Math.PI/180))*180/Math.PI;	
			
			// CALCOLO DELTA (m) MERIDIANO, SORGERE E TRAMONTO 
			var alma_delta0 = - alma_Hour0 / 360;
			var alma_delta1 = (alma_h1 - alma_h0) / (360 * Math.cos(alma_dec_int1*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour1*r));
			var alma_delta2 = (alma_h2 - alma_h0) / (360 * Math.cos(alma_dec_int2*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour2*r));

 			// AGGIUNTA AI VALORI DI (m) I RELATIVI DELTA (m) PER IL MERIDIANO, SORGERE E TRAMONTO E RELATIVA CONVERSIONE IL 24 ESIMI 
			var alma_sorgere = (alma_m1 + alma_delta1) * 24; 
			var alma_meridiano = (alma_m0 + alma_delta0) * 24;
			var alma_tramonto = (alma_m2 + alma_delta2) * 24; 
			
			// CONDIZIONI CHE SERVONO QUANDO L'ORARIO E' NEGATIVO OPPURE OLTRE LA 24 ESIMA ORA 
			// -------------------------------------------------------------------------------
			// SORGERE  			
			if(alma_sorgere < 0){alma_sorgere = alma_sorgere + 24}
			if(alma_sorgere >= 24 ){alma_sorgere = alma_sorgere - 24}
			
			// MERIDIANO 
			if(alma_meridiano < 0){alma_meridiano = alma_meridiano + 24}
			if(alma_meridiano >= 24 ){alma_meridiano = alma_meridiano - 24}
			
			// TRAMONTO
			if(alma_tramonto < 0){alma_tramonto = alma_tramonto + 24}
			if(alma_tramonto >= 24 ){alma_tramonto = alma_tramonto - 24}
			// --------------------------------------------------------------------------------

			// CONVERSIONE DEI TEMPI IN ORE E RISULTATI FINALI IN LINEA 
 			var sorgere_H = Math.floor(alma_sorgere); 
			var sorgere_M_dec = (alma_sorgere - sorgere_H) * 60; 
			var sorgere_M = Math.floor(sorgere_M_dec); 
			var sorgere_S = (sorgere_M_dec - sorgere_M) * 60; 

//			var sorgere_cambio_data = "stesso giorno"; 
			var sorgere_HL = sorgere_H + fuso;
			if(sorgere_HL < 0) {sorgere_HL = sorgere_HL + 24} 
			if(sorgere_HL >= 24) {sorgere_HL = sorgere_HL - 24 }

			var sorgere = "Tempo Universale" + '\n' + myParseFloat_null((sorgere_H)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2))  + '\n' + '\n' + "Tempo Civile" + '\n' + myParseFloat_null((sorgere_HL)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2));


 			var tramonto_H = Math.floor(alma_tramonto); 
			var tramonto_M_dec = (alma_tramonto - tramonto_H) * 60; 
			var tramonto_M = Math.floor(tramonto_M_dec); 
			var tramonto_S = (tramonto_M_dec - tramonto_M) * 60; 

//			var tramonto_cambio_data = "stesso giorno"; 
			var tramonto_HL = tramonto_H + fuso;
			if(tramonto_HL < 0) {tramonto_HL = tramonto_HL + 24 }
			if(tramonto_HL >= 24) {tramonto_HL = tramonto_HL - 24 }

			var tramonto = "Tempo Universale" + '\n' + myParseFloat_null((tramonto_H)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2)) + '\n' + '\n' + "Tempo Civile" + '\n' + myParseFloat_null((tramonto_HL)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2));

		}



			obj.S_URANUS_APP.value = sorgere;
			obj.T_URANUS_APP.value = tramonto;


// -------------------------------------------- FINE CALCOLO SORGERE MERIDIANO E TRAMONTO APPARENTE  -----------------------------------------------------------------------------



			// RISULTATI CHE SERVONO PER IL PULSANTE VISIBILITA' DI SOLE, LUNA E PIANETI 
			return [sorgere_tc,meridiano_tc,tramonto_tc]
				
		
			}
		else 
			{
				alert("ERRORE\n\nHAI TENTATO DI MODIFICARE LA PAGINA WEB\n\nSPIACENTE IL PROGRAMMA NON FUNZIONERA' PIU'"); 
			}
		
	}
