// grafica sistema solare
  function graphic(obj)
  {  

			// -------------------- inizio grafico dati in comune a tutti i pianeti ------------------------------ 
			var canvas = document.getElementById('myCanvas');
		  	var context = canvas.getContext('2d');

			// resetta la scala così quando viene ridisegnato il grafico non rimane la scala precedente  
			context.setTransform(1, 0, 0, 1, 0, 0);		
			
			// pulisce tutto il canvas 
			context.clearRect(0, 0, canvas.width, canvas.height);
			
			// scelta della scala che proviene dal selettore nella pagina web principale 
			var scelta_scala = obj.scala_select.value;
			
			
			// il canvas è di 800 x 800 pixels e 50 pixels nella scala 1:1 corrispondono ad 1 UA quindi 
			// il raggio (radius) dei pianeti nella scala 1:1 è di 5 pixel  
			// scala 0.25 tutto il canvas in questa scala è di 800 / (50 x 0.25) = 64 UA
			if (scelta_scala == 1)
				{
					var x_scale = 0.25;
					var y_scale = 0.25;					
					context.font = "64px Arial";
					// 5 / 0.25 = 20
					var radius = 20;
					// 1 / 0.25 = 40
					var linea = 40;
				}

			// scala 0.50 tutto il canvas in questa scala è di 800 / (50 x 0.50) = 32 UA
			if (scelta_scala == 2)
				{
					var x_scale = 0.50;
					var y_scale = 0.50;
					context.font = "32px Arial";
					// 5 / 0.5 = 10
					var radius = 10;
					// 1 / 0.5 = 20
					var linea = 20;

				}

			// scala 0.75 tutto il canvas in questa scala è di 800 / (50 x 0.75) = 21.33 UA
			if (scelta_scala == 3)
				{
					var x_scale = 0.75;
					var y_scale = 0.75;
					context.font = "21px Arial";
					// 5 / 0.75 = 6.66
					var radius = 6.5;
					// 1 / 0.75 = 13.33
					var linea = 13.33;
				}

			// scala 1 tutto il canvas in questa scala è di 800 / (50 x 1) = 16 UA
			if (scelta_scala == 4)
				{
					var x_scale = 1;
					var y_scale = 1;
					context.font = "16px Arial";
					// 5 / 1 = 5
					var radius = 5;
					// 1 / 1 = 10
					var linea = 10;
				}

			// scala 1.25 tutto il canvas in questa scala è di 800 / (50 x 1.25) = 12.8 UA
			if (scelta_scala == 5)
				{
					var x_scale = 1.25;
					var y_scale = 1.25;
					context.font = "13px Arial";
					// 5 / 1.25 = 4
					var radius = 4;
					// 1 / 1.25 = 8
					var linea = 8;
				}

			// scala 1.5 tutto il canvas in questa scala è di 800 / (50 x 1.5) = 10.6 UA
			if (scelta_scala == 6)
				{
					var x_scale = 1.50;
					var y_scale = 1.50;
					context.font = "11px Arial";
					// 5 / 1.5 = 3.33
					var radius = 3.5;
					// 1 / 1.5 = 6.6
					var linea = 6.6;
				}

			// scala 1.75 tutto il canvas in questa scala è di 800 / (50 x 1.75) = 9.14 UA
			if (scelta_scala == 7)
				{
					var x_scale = 1.75;
					var y_scale = 1.75;
					context.font = "9px Arial";
					// 5 / 1.75 = 2.8
					var radius = 2.8;
					// 1 / 1.75 = 5.7
					var linea = 5.7;
				}

			// scala 2 tutto il canvas in questa scala è di 800 / (50 x 2) = 8 UA
			if (scelta_scala == 8)
				{
					var x_scale = 2;
					var y_scale = 2;
					context.font = "8px Arial";
					// 5 / 2 = 2.5 
					var radius = 2.5;
					// 1 / 2 = 0.5
					var linea = 5;
				}

			// scala 3 tutto il canvas in questa scala è di 800 / (50 x 3) = 5.33 UA
			if (scelta_scala == 9)
				{
					var x_scale = 3;
					var y_scale = 3;
					context.font = "5px Arial";
					// 5 / 3 = 1.66
					var radius = 1.5;
					// 1 / 3 = 0.33
					var linea = 3.3;
				}

			// scala 4 tutto il canvas in questa scala è di 800 / (50 x 4) = 4 UA
			if (scelta_scala == 10)
				{
					var x_scale = 4;
					var y_scale = 4;
					context.font = "5px Arial";
					// 5 / 4 = 1.25
					var radius = 1.5;
					// 1 / 4 = 0.25
					var linea = 2.5;
				}

			// scala 5 tutto il canvas in questa scala è di 800 / (50 x 5) = 3.2 UA
			if (scelta_scala == 11)
				{
					var x_scale = 5;
					var y_scale = 5;
					context.font = "5px Arial";
					// 5 / 5 = 1 
					var radius = 1.5;
					// 1 / 5 = 0.2
					var linea = 2;
				}

			// scala 6 tutto il canvas in questa scala è di 800 / (50 x 6) = 2.66 UA
			if (scelta_scala == 12)
				{
					var x_scale = 6;
					var y_scale = 6;
					context.font = "5px Arial";
					// 5 / 6 = 0.8333
					var radius = 1.5;
					// 1 / 6 = 0.16
					var linea = 1.6;
				}



			// scala del grafico (zoom)
			context.scale(x_scale, y_scale);
			
			// coordinate del centro 
		  	var centerX = canvas.width / x_scale / 2;
		  	var centerY = canvas.height / y_scale / 2;
		  	
			// raggio del sole 
			//var radius = 5;
			
			// scala del grafico es: 1 UA = 50 pixels  
		  	var pix = 50;
		  	
			
			//var font_testo = "10px Arial";
		  	var dist_testo = 3;
	
	
			
			// opzione griglia 
			var griglia_si = 0;
			var griglia_no = 1;
			
			if (obj.scelta_griglia[griglia_si].checked)
				{
					var scelta_griglia = 0;
				}
			if (obj.scelta_griglia[griglia_no].checked)
				{
					var scelta_griglia = 1; 
				}

			 if (scelta_griglia == 0) 
	 			{
	      			context.beginPath();
					context.setLineDash([1, 1]);
					context.beginPath();
					
  					for (i=0 ; i<2000; i+= 50)
	  					{
					context.moveTo(canvas.width / x_scale / 2 + i , 0);
      				context.lineTo(canvas.width / x_scale / 2 + i , canvas.height / y_scale);

					context.moveTo(canvas.width / x_scale / 2 - i , 0);
      				context.lineTo(canvas.width / x_scale / 2 - i , canvas.height / y_scale);

					context.moveTo(0 , canvas.height / y_scale / 2 + i);
      				context.lineTo(canvas.width / x_scale , canvas.height / y_scale / 2 + i);
					context.moveTo(0 , canvas.height / y_scale / 2 - i);
      				context.lineTo(canvas.width / x_scale , canvas.height / y_scale / 2 - i);
	  					}
					
      				context.strokeStyle = '#FFF';
      				context.stroke();
					//context.setLineDash([0, 0]);
				}
			

					// linea punto gamma 
	      			context.beginPath();
					// context.setLineDash([1, 1]);
					context.beginPath();
					// Muove il cursore in basso ed al centro 
					context.moveTo(canvas.width / x_scale / 2  , canvas.height / y_scale );
					// traccia la linea verticale della freccia del punto gamma 
      				context.lineTo(canvas.width / x_scale / 2   , canvas.height / y_scale - linea * 4);
					
					
					// Muove il cursore in basso ed al centro 
					context.moveTo(canvas.width / x_scale / 2  , canvas.height / y_scale );
      				// Traccia la linea obliqua della freccia  
					context.lineTo(canvas.width / x_scale / 2 - linea   , canvas.height / y_scale - linea);
					
					// Muove il cursore in basso ed al centro 
					context.moveTo(canvas.width / x_scale / 2  , canvas.height / y_scale );
      				// Traccia la linea della obliqua freccia 
					context.lineTo(canvas.width / x_scale / 2 + linea   , canvas.height / y_scale - linea);
					
					
					
					
      				context.strokeStyle = '#FFF';
      				context.stroke();

		
		
		
					// cerchio punto gamma 
		      		context.beginPath();
					context.arc(canvas.width / x_scale / 2, canvas.height / y_scale , radius  / 4, 0, 2 * Math.PI, false);
					context.fillStyle = '#FFFF00';
					context.fill();


					context.fillText("Punto Gamma",canvas.width / x_scale / 2 + linea * 2 , canvas.height / y_scale);

		
			
				// var image_sole = document.getElementById("sole");

				// context.drawImage(image_sole, centerX-radius, centerY-radius, 30, 30);			
			
			
			
			// sole ------------------------------------------------------------------------------------
			// inizio del percorso di tracciamento   
      		context.beginPath();

			// definisce l'arco che crea il cerchietto del sole (x,y,raggio,ang part,angolo di fine
      		context.arc(centerX, centerY, radius, 0, 2 * Math.PI, false);

			// colore dell'arco
		    context.fillStyle = '#FFFF00';

			// riempimento dell' arco  
      		context.fill();

			// eventuale bordo del cerchietto del sole 
      		//context.lineWidth = 5;
      		//context.strokeStyle = 'yellow';
    		//context.stroke();

			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
					context.fillText("Sole",centerX+dist_testo, centerY-dist_testo);
				}


			
			

	 		// mercury --------------------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma mercury_tab
			var L = mercury_tab(obj)[0];
			var R = mercury_tab(obj)[2];
	
			// coordinate del centro di mercurio 
			var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
			var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);

			// comincia un nuovo percorso		  
			context.beginPath();
			
			// definisce l'arco che crea il cerchietto di mercurio 
		  	context.arc(x,y, radius, 0, 2 * Math.PI, false);   
			context.fillStyle = '#993300';
			context.fill();

			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#993300';
					context.setLineDash([1, 1]);

      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Mercurio",x+dist_testo, y-dist_testo);
				}


	 		// venus ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = venus_tab(obj)[0];
			var R = venus_tab(obj)[2];
			
			// coordinate del centro di venere 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto di venere 
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#3FF';
      		context.fill();
			
			// eventuale bordo del cerchietto di venere  
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#3FF';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Venere",x+dist_testo, y-dist_testo);
				}
			

	 		// terra ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			
			var L = earth_vsop87()[0];
			var R = earth_vsop87()[2];
			
			// coordinate del centro della terra 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto della terra
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#0000FF';
      		context.fill();
		
			// eventuale bordo del cerchietto della terra
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#0000FF';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Terra",x+dist_testo, y-dist_testo);
				}

			
			
			
			

			// GRAFICO DELLA LUNA 
			// comincia un nuovo percorso
      		context.beginPath();

			// LONGITUDINE ECCLITTICA APPARENTE GEOCENTRICA DELLA LUNA 
			var L_luna = luna_tab(obj)[0];

			// COORDINATE DEL CENTRO DELLA LUNA (IL NUMERO 3 SONO I PIXEL CHE STACCANO LA TERRA DALLA LUNA MA NON SONO IN SCALA)  
	  		var x_luna = x + (3 * Math.sin(L_luna*Math.PI/180)) ;
	  		var y_luna = y + (3 * Math.cos(L_luna*Math.PI/180)) ;

			// DISEGNA LA LUNA (QUI IL RADIUS E' 0.8174 PIXEL PER RIMPICCIOLIRE LA LUNA IN PROPORZIONE ALLA TERRA CON LA SCALA A 2.66 UA)
      		context.arc(x_luna,y_luna, 0.8174  , 0, 2 * Math.PI, false);
      		context.fillStyle = '#FFFFFF';
      		context.fill();


	 		// marte ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = mars_tab(obj)[0];
			var R = mars_tab(obj)[2];
			
			// coordinate del centro della marte 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto della marte
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#FF0000';
      		context.fill();
			
			// eventuale bordo del cerchietto della marte
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#FF0000';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Marte",x+dist_testo, y-dist_testo);
				}


	 		// giove ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = jupiter_tab(obj)[0];
			var R = jupiter_tab(obj)[2];
			
			// coordinate del centro della giove 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto della giove
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#CC6699';
      		context.fill();
			
			// eventuale bordo del cerchietto della giove
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#CC6699';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Giove",x+dist_testo, y-dist_testo);
				}

	 		// saturno ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = saturn_tab(obj)[0];
			var R = saturn_tab(obj)[2];
			
			// coordinate del centro della saturno 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto della saturno
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#6666FF';
      		context.fill();
			
			// eventuale bordo del cerchietto della saturno
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#6666FF';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Saturno",x+dist_testo, y-dist_testo);
				}

	 		// urano ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = uranus_tab(obj)[0];
			var R = uranus_tab(obj)[2];
			
			// coordinate del centro di urano 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto della urano
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#CC33FF';
      		context.fill();
			
			// eventuale bordo del cerchietto di urano
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#CC33FF';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Urano",x+dist_testo, y-dist_testo);
				}


	 		// nettuno ------------------------------------------------------------------------------
			// prende i dati longitudine e raggio vettore dal programma venus_tab
			var L = neptune_tab(obj)[0];
			var R = neptune_tab(obj)[2];
			
			// coordinate del centro della urano 
	  		var x = centerX + (R * Math.sin(L*Math.PI/180) * pix);
	  		var y = centerY + (R * Math.cos(L*Math.PI/180) * pix);
			
			// comincia un nuovo percorso
      		context.beginPath();
			
			// definisce l'arco che crea il cerchietto di urano
      		context.arc(x,y, radius, 0, 2 * Math.PI, false);
      		context.fillStyle = '#3366FF';
      		context.fill();
			
			// eventuale bordo del cerchietto di urano
      		//context.lineWidth = 5;
      		//context.strokeStyle = '#003300';
      		//context.stroke();
      		
			// opzione orbita 
			var orbita_si = 0;
			var orbita_no = 1;
			
			if (obj.scelta_orbita[orbita_si].checked)
				{
					var scelta_orbita = 0;
				}
			if (obj.scelta_orbita[orbita_no].checked)
				{
					var scelta_orbita = 1; 
				}

			 if (scelta_orbita == 0) 
	 			{
					context.beginPath();
					context.arc(centerX,centerY, R*pix, 0, 2 * Math.PI, false);
      				context.strokeStyle = '#3366FF';
      				context.stroke();
				}
			
			// opzione nome 
			var nome_si = 0;
			var nome_no = 1;
			
			if (obj.scelta_nome[nome_si].checked)
				{
					var scelta_nome = 0;
				}
			if (obj.scelta_nome[nome_no].checked)
				{
					var scelta_nome = 1; 
				}

			 if (scelta_nome == 0) 
	 			{
	  				context.fillText("Nettuno",x+dist_testo, y-dist_testo);
				}



  }

