	
  // CALCOLO ALGORITMO GIULIANO DEL SOLE   
	
  function calc_1()
  {  
  
	  // Tempo in secoli Giuliani dall'epoca J2000 alla data della misurazione   
	  T = (JD_UT - JD_J2K) / 36525;   
  
	  
	  // longitudine media geometrica del sole 
	  L = 280.46646 + 36000.76983 * T + 0.0003032 * Math.pow(T,2);	
  
	  // anomalia media geometrica del sole 
	  M = 357.52911 + 35999.05029 * T - 0.0001537 * Math.pow(T,2);  	
		  
	  // equazione del centro del sole 
	  C = (1.914602 - 0.004817 * T - 0.000014 * Math.pow(T,2))* Math.sin(M*Math.PI/180)+(0.019993 - 0.000101 * T)* Math.sin((2*M)*Math.PI/180)+0.000289 * Math.sin((3*M)*Math.PI/180);
		  
	  // longitudine vera del sole 
	  LV = L + C;
  
	  // longitudine apparente del sole 
	  LA = LV - 0.00569 - 0.00478 * Math.sin((125.04 - 1934.136 * T)*Math.PI/180);
  
	  U = T / 100;
		  
	  // Obliquità E  
	  E_g = 23;
	  E_p = 26;
	  E_ss = 21.448;
		  
	  E = E_ss / 3600 + E_p / 60 + E_g;
		  
	  // parametri necessari per la formula seguente 
	  a1 = 4680.93 / 3600;
	  b1 = 1.55 / 3600;
	  c1 = 1999.25 / 3600;
	  d1 = 51.38 / 3600;
	  e1 = 249.67 / 3600;
	  f1 = 39.05 / 3600;
	  g1 = 7.12 / 3600 ;
	  h1 = 27.87 / 3600;
	  i1 = 5.79 / 3600;
	  l1 = 2.45 / 3600;
		  
	  // formula per l'obliquità 
	  E1 = E - a1 * U - b1 * Math.pow(U,2) + c1 * Math.pow(U,3) - d1 * Math.pow(U,4) - e1 * Math.pow(U,5) - f1 * Math.pow(U,6) + g1 * Math.pow(U,7) + h1 * Math.pow(U,8) + i1 * Math.pow(U,9) + l1 * Math.pow(U,10);
  
	  // Calcolo della declinazione del sole 
	  a = Math.sin(E1*Math.PI/180)*Math.sin(LA*Math.PI/180);
	  DS = Math.asin(a)*180/Math.PI;
	  
	  // Calcolo della eccentricità dell'orbita 
	  EC = 0.016708634 - 0.000042037 * T - 0.0000001267 * Math.pow(T,2); 
  
	  // Calcolo dell'equazione del tempo 	
	  ET_RAD = Math.pow(Math.tan(E1 / 2*Math.PI/180),2)*Math.sin(2*L*Math.PI/180)-2*EC*Math.sin(M*Math.PI/180)+(4*EC)*Math.pow(Math.tan(E1 / 2*Math.PI/180),2)*Math.sin(M*Math.PI/180)*Math.cos(2*L*Math.PI/180)-(1/2)*Math.pow(Math.tan(E1 / 2*Math.PI/180),4)*Math.sin(4*L*Math.PI/180)-(5/4)*Math.pow(EC,2)*Math.sin(2*M*Math.PI/180);
	  
	  ET = ET_RAD * 180 / Math.PI / 15;
	  
	  // Calcolo dell'angolo orario del Sole 
	  long_dec = long_dec; 
	  H_sole = (ore_dec2 - 12) * 15 - long_dec*-1 + ET * 15;  
	  	  
	  // Calcolo dell'altezza  geometrica del centro del sole 
	  h = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(DS*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(DS*Math.PI/180)*Math.cos(H_sole*Math.PI/180))*180/Math.PI;
  
	  // Calcolo dell' azimut del sole con formula nautica della tangente 
	  // Formula azimut numeratore 
	  n = Math.sin(H_sole*Math.PI/180);
		  
	  // Formula azimut denominatore 
	  d = Math.tan(DS*Math.PI/180)*Math.cos(lat_dec*Math.PI/180)-Math.sin(lat_dec*Math.PI/180)*Math.cos(H_sole*Math.PI/180);
		  
	  // azimut 
	  az = Math.atan(n/d)*180/Math.PI;
		  
	  if (n > 0 && d < 0) 
		  {
			  az = az + 180 ;
		  }
		  
	  if (n < 0 && d > 0)	
		  {
			  az = az + 360 ;
		  }
		  
	  if (n < 0 && d < 0)	
		  {
			  az = az + 180 ;
		  }
  
	  if (H_sole < 180) 
		  {
			  az = 360 - az; 
		  }
	  
	  // questa condizione non si può mettere perchè quando il sole è a destra bisogra sottrarre a partire dai 360° e non da 0° altrimenti viene negativo  	
	  // if(az >=360) {az = az -360};
  
	  // Calcolo dell' azimut del sole con formula nautica del coseno 
	  // az = Math.acos((Math.sin(d1_dec*Math.PI/180)-Math.sin(lat_dec*Math.PI/180)*Math.sin(h*Math.PI/180))/(Math.cos(lat_dec*Math.PI/180)*Math.cos(h*Math.PI/180)))*180/Math.PI;
			  
	  // if (tv2_dec < 180) {az = 360 - az;}
  
  
	  az_a1 = az + ar1_dec;
	  
	  // Condizione che serve per trasformare l'azimut dell'allineamento se negativo
	  if(az_a1 <0){az_a1 = az_a1 + 360};
 
	  
	  // condizioni per il calcolo dell'allineamento reciproco 
	  if (az_a1 >= 180) {az_a_rec = az_a1 - 180};
	  if (az_a1 < 180) {az_a_rec = az_a1 + 180}; 
  
  
	  // radice quadrata della quota media di elevazione dell'osservatore 
	  rq_qm = Math.sqrt(qm);
	  
  // ---------------------- solo per visualizzare i dati delle altezze nella schermata dei dettagli ------------------------	
	  
	  // Formula semplificata
	  if (sceltaf == 0) // Formula semplificata
	  	{ 
			// altezza vera corretta di stella 
			hv = ho_dec - 0.03 * rq_qm - rm_dec;
	  		hvc_stella = hv;
	  
	  		// altezza vera corretta del pianeta 
			hv = ho_dec - 0.03 * rq_qm - rm_dec + (parall_p_dec * Math.cos(ho_dec * Math.PI / 180));
	  		hvc_pianeta = hv;
  
	  		// altezza vera corretta del sole 
			hv = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec + (pars_dec * Math.cos(ho_dec * Math.PI / 180));
	  		hvc_sole = hv;
  
	  		// altezza vera corretta della luna 
			hv = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec + (parl_dec * Math.cos(ho_dec * Math.PI / 180));
	   		hvc_luna = hv;
		}
	  
	  // Formula Nautica
	  if (sceltaf == 1) // Formula Nautica
	  	{ 
			// altezza vera corretta di stella 
			hv = ho_dec - 0.03 * rq_qm - rm_dec;
	  		hvc_stella = hv;
	  
	  		// altezza vera corretta del pianeta 
			hv1 = ho_dec - 0.03 * rq_qm - rm_dec; 
			hv3= Math.sin((parall_p_dec - parall_p_dec * (1 / 298.257) * Math.pow(Math.sin(lat_dec * Math.PI / 180),2)) * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180);
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 			
			hvc_pianeta = hv1 + hv4;
  
	  		// altezza vera corretta del sole 
			hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(pars_dec * Math.PI / 180));
			hv3 = Math.sin((pars_dec - pars_dec * (1 / 298.257) * Math.pow(Math.sin(lat_dec * Math.PI / 180),2))*Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180);   
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 			
			hvc_sole = hv1 + hv4;
  
	  		// altezza vera corretta della luna 
			hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parl_dec * Math.PI / 180)); 
			hv3 = Math.sin((parl_dec - parl_dec * (1 / 298.257) * Math.pow(Math.sin(lat_dec * Math.PI / 180),2))*Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180);
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 				   		
			hvc_luna = hv1 + hv4;
		}
	  
	  // Formula Geodetica	
	  if (sceltaf == 2) // Formula Geodetica
	  	{ 
	  		// altezza vera corretta di stella
			hv = ho_dec - 0.03 * rq_qm - rm_dec;
	  		hvc_stella = hv;
	  
	  		// altezza vera corretta del pianeta 
	  		hv1 = ho_dec - 0.03 * rq_qm - rm_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parall_p_dec * Math.PI / 180));
	  		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(parall_p_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	  		hvc_pianeta = (hv1 + hv4);
  
	  		// altezza vera corretta del sole 
	  		hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(pars_dec * Math.PI / 180));
	  		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(pars_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	  		hvc_sole = (hv1 + hv4);
  
	  		// altezza vera corretta della luna 
	   		hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parl_dec * Math.PI / 180));
	   		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(parl_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	   		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	   		hvc_luna = (hv1 + hv4);
		}
	  
  
  // ------------------------------- fine sequenza ----------------------------------------------	
	  
  	  // Scelta della stella 	
	  if (temp == 0)
	  {
	  	  // Scelta del calcolo semplificato				
		  if (sceltaf == 0)
		  	{
				hv = ho_dec - 0.03 * rq_qm - rm_dec;
			}
		  // Scelta del calcolo Nautico 
		  if (sceltaf == 1)
		  	{
				hv = ho_dec - 0.03 * rq_qm - rm_dec;
			}
		  // Scelta del calcolo Geodetico 
		  if (sceltaf == 2)
		  	{
	  			// Formula hv Geodetica stelle
				hv = ho_dec - 0.03 * rq_qm - rm_dec;
			}
	  }

	  //Scelta del Pianeta   
	  if (temp == 1)
	  {
	  	  // Scelta del calcolo semplificato				
		  if (sceltaf == 0)
		  	{
				hv = ho_dec - 0.03 * rq_qm - rm_dec + (parall_p_dec * Math.cos(ho_dec * Math.PI / 180));
			}
		  // Scelta del calcolo Nautico 
		  if (sceltaf == 1)
		  	{
				hv1 = ho_dec - 0.03 * rq_qm - rm_dec; 
				hv3= Math.sin((parall_p_dec - parall_p_dec * (1 / 298.257) * Math.pow(Math.sin(lat_dec * Math.PI / 180),2)) * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180);
	  			hv4 = Math.asin(hv3) * 180 / Math.PI; 			
				hv = hv1 + hv4;
			}
		  // Scelta del calcolo Geodetico 
		  if (sceltaf == 2)
		  	{
				// Formula hv Geodetica pianeti
	    		hv1 = ho_dec - 0.03 * rq_qm - rm_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parall_p_dec * Math.PI / 180));
	    		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(parall_p_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	    		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	    		hv = (hv1 + hv4);
			}
	  }
	  
      // Scelta del Sole 
	  if (temp == 2)
	  {
	  	  // Scelta del calcolo semplificato				
		  if (sceltaf == 0)
		  	{
				hv = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec + (pars_dec * Math.cos(ho_dec * Math.PI / 180));
			}
		  // Scelta del calcolo Nautico 
		  if (sceltaf == 1)
		  	{
		  		hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(pars_dec * Math.PI / 180));
		  		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(pars_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 	
		  		hv4 = Math.asin(hv3) * 180 / Math.PI; 
				hv = hv1 + hv4;
			}
		  // Scelta del calcolo Geodetico 
		  if (sceltaf == 2)
		  	{
  		  	    // Formula hv Geodetica sole
	    		hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sds_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(pars_dec * Math.PI / 180));
	    		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(pars_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	    		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	    		hv = (hv1 + hv4);

			}

	  }
	  
	  // Scelta della luna
	  if (temp == 3)
	  {
	  	  // Scelta del calcolo semplificato				
		  if (sceltaf == 0)
		  	{
				hv = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec + (parl_dec * Math.cos(ho_dec * Math.PI / 180));
			}
		  // Scelta del calcolo Nautico 
		  if (sceltaf == 1)
		  	{
			hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parl_dec * Math.PI / 180)); 
			hv3 = Math.sin((parl_dec - parl_dec * (1 / 298.257) * Math.pow(Math.sin(lat_dec * Math.PI / 180),2))*Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180);
	  		hv4 = Math.asin(hv3) * 180 / Math.PI; 				   		
			hv = hv1 + hv4;
			}
		  // Scelta del calcolo Geodetico 
		  if (sceltaf == 2)
		  	{
	     		// Formula hv Geodetica luna
	     		hv1 = ho_dec - 0.03 * rq_qm - rm_dec + sdl_dec * (1 + Math.sin((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180) * Math.sin(parl_dec * Math.PI / 180));
	     		hv3 = (0.9983271 + 0.0016764 * Math.cos((2 * lat_dec) * Math.PI / 180) - 0.0000035 * Math.cos((4 * lat_dec) * Math.PI / 180)) * Math.sin(parl_dec * Math.PI / 180) * Math.cos((ho_dec - 0.03 * rq_qm - rm_dec) * Math.PI / 180); 
	     		hv4 = Math.asin(hv3) * 180 / Math.PI; 
	     		hv = (hv1 + hv4);

			}
	  }
	  
	  
	  // Calcolo declinazione allineamento 
	  d_all_1 = Math.sin(lat_dec*Math.PI/180) * Math.sin(hv*Math.PI/180) + Math.cos(lat_dec*Math.PI/180) * Math.cos(hv*Math.PI/180) * Math.cos(az_a1*Math.PI/180);
	  d_all_1 = Math.asin(d_all_1)*180/Math.PI; 
	  
	  // Calcolo declinazione allineamento reciproco 
	  d_all_rec = Math.sin(lat_dec*Math.PI/180) * Math.sin(hv*Math.PI/180) + Math.cos(lat_dec*Math.PI/180) * Math.cos(hv*Math.PI/180) * Math.cos(az_a_rec*Math.PI/180);
	  d_all_rec = Math.asin(d_all_rec)*180/Math.PI; 
	  
	  
	  // Conversioni dei Dati in Gradi primi e secondi 
			  
	  // Conversione azimut in gradi primi e secondi 
	  azim_G = Math.floor(az);		
	  azim_M_dec = (az - azim_G) * 60;
	  azim_M = Math.floor(azim_M_dec) ;
	  azim_S = (azim_M_dec - azim_M) * 60 ;
  
	  // Conversione azimut allineamento in gradi primi e secondi 
	  azim1_G = Math.floor(az_a1);		
	  azim1_M_dec = (az_a1 - azim1_G) * 60;
	  azim1_M = Math.floor(azim1_M_dec) ;
	  azim1_S = (azim1_M_dec - azim1_M) * 60 ;
	  
	  // Conversione declinazione allineamento in gradi primi e secondi 
	  d_all_abs = Math.abs(d_all_1); 
	  d_all_G = Math.floor(d_all_abs);		
	  d_all_M_dec = (d_all_abs - d_all_G) * 60;
	  d_all_M = Math.floor(d_all_M_dec) ;
	  d_all_S = (d_all_M_dec - d_all_M) * 60 ;
	  d_all_SGN = "+ ";
	  if (d_all_1 < 0)
		  {
			  d_all_SGN = "- ";
		  }
	  
	  
	  // Conversione declinazione allineamento reciproco in gradi primi e secondi 
	  d_all_rec_abs = Math.abs(d_all_rec); 
	  d_all_rec_G = Math.floor(d_all_rec_abs);		
	  d_all_rec_M_dec = (d_all_rec_abs - d_all_rec_G) * 60;
	  d_all_rec_M = Math.floor(d_all_rec_M_dec) ;
	  d_all_rec_S = (d_all_rec_M_dec - d_all_rec_M) * 60 ;
	  d_all_rec_SGN = "+ ";
	  if (d_all_rec < 0)
		  {
			  d_all_rec_SGN = "- ";
		  }
	  
  		// Dati non più utilizzati, fanno riferimento alla V01 che comprendeva 
		// l'inserimento dell'epoca di costruzione del monumento
		// siccome sono presenti nella lista dei return è necessario comunque dargli un valore
		// per mantenere intatta la numerazione dei valori di return  
	  	T1 = 10; 
		d_sott = 10;
		d_sott_rec = 10; 
  
  
  
  
  
  
  
	  return [T,L,M,C,LV,LA,E1,DS,EC,ET,H_sole,h,az,az_a1,hv,d_all_1,T1,d_sott,U,az_a_rec,d_all_rec,d_sott_rec,hvc_stella,hvc_pianeta,hvc_sole,hvc_luna,azim_G,azim_M,azim_S,azim1_G,azim1_M,azim1_S,d_all_G,d_all_M,d_all_S,d_all_SGN,d_all_rec_G,d_all_rec_M,d_all_rec_S,d_all_rec_SGN];
		
  
  
  
  }
	  
	  
	  
	  