  function vondrak_matrix(a,b,c) 
  {
	  this.a = a;
	  this.b = b;
	  this.c = c;
  }


function vondrak(obj)
{  

	jd = myParseFloat(obj.JD.value);
	
	astro_mps = myParseFloat(obj.ASTRO_MPS.value); 	
	astro_mpss = myParseFloat(obj.ASTRO_MPSS.value); 	

	ar_0 = myParseFloat(obj.AR.value);
	dec_0 = myParseFloat(obj.DEC.value);
	
	obj.T_EQR.value = vondrak_peqt()[0];
	obj.V1_EQR.value = vondrak_peqt()[1];
	obj.V2_EQR.value = vondrak_peqt()[2];
	obj.V3_EQR.value = vondrak_peqt()[3];
	
	obj.T_ECL.value = vondrak_pecl()[0];
	obj.V1_ECL.value = vondrak_pecl()[1];
	obj.V2_ECL.value = vondrak_pecl()[2];
	obj.V3_ECL.value = vondrak_pecl()[3];
	obj.P_A_ECL.value = vondrak_pecl()[4];
	obj.Q_A_ECL.value = vondrak_pecl()[5];
	
	obj.PX.value = vondrak_pxp()[0];
	obj.PY.value = vondrak_pxp()[1];
	obj.PZ.value = vondrak_pxp()[2];
	
	obj.R.value = vondrak_pn()[0];
	obj.U1.value = vondrak_pn()[1];
	obj.U2.value = vondrak_pn()[2];
	obj.U3.value = vondrak_pn()[3];
	
	obj.V1.value = vondrak_pxp_1()[0];
	obj.V2.value = vondrak_pxp_1()[1];
	obj.V3.value = vondrak_pxp_1()[2];
	
  	var serie_xyz = new Array(
  	new vondrak_matrix( vondrak_pn()[1], vondrak_pn()[2],vondrak_pn()[3]),
    new vondrak_matrix( vondrak_pxp_1()[0],vondrak_pxp_1()[1],vondrak_pxp_1()[2]),
    new vondrak_matrix( vondrak_peqt()[1],vondrak_peqt()[2],vondrak_peqt()[3]));
	
	obj.MATRIX_0_0.value = serie_xyz[0].a;
	obj.MATRIX_0_1.value = serie_xyz[0].b;
	obj.MATRIX_0_2.value = serie_xyz[0].c;
	
	obj.MATRIX_1_0.value = serie_xyz[1].a;
	obj.MATRIX_1_1.value = serie_xyz[1].b;
	obj.MATRIX_1_2.value = serie_xyz[1].c;
	
	obj.MATRIX_2_0.value = serie_xyz[2].a;
	obj.MATRIX_2_1.value = serie_xyz[2].b;
	obj.MATRIX_2_2.value = serie_xyz[2].c;
	
	
	
	var t = (jd - 2451545.0)/36525;

	var corr_mp_ra = t  * 100 * astro_mps; // il moto proprio  espresso in secondi 
		corr_mp_ra = (corr_mp_ra / 3600) * 15;   	
		
	// ascensione retta dopo la correzione moti propri 
	var ar_1 = 	ar_0 + corr_mp_ra;
		 
	var corr_mp_dec = t * 100 * astro_mpss; // il moto proprio espresso in secondi 
		corr_mp_dec = (corr_mp_dec / 3600); 

	// declinazione dopo la correzione dei moti propri  
	var dec_1 = dec_0 + corr_mp_dec;
	
	
	var x0 = Math.cos(ar_1*Math.PI/180) * Math.cos(dec_1*Math.PI/180);
	var y0 = Math.sin(ar_1*Math.PI/180) * Math.cos(dec_1*Math.PI/180);
	var z0 = Math.sin(dec_1*Math.PI/180);
	
	var x1 = x0 * serie_xyz[0].a + y0 * serie_xyz[0].b + z0 * serie_xyz[0].c;
	var y1 = x0 * serie_xyz[1].a + y0 * serie_xyz[1].b + z0 * serie_xyz[1].c; 
	var z1 = x0 * serie_xyz[2].a + y0 * serie_xyz[2].b + z0 * serie_xyz[2].c; 
	
	var ar_2 = Math.atan2(y1,x1)*180/Math.PI; 
	var dec_2 = Math.asin(z1)*180/Math.PI; 
	
	var dra2 = ar_2;
	var ddec2 = dec_2;
	
	
	
	
	
	

	  	// Formula L 
	  	var L = 280.4665+36000.7698*t+0.000303*Math.pow(t,2);
  		/*	
  		Ldec = L/360;
	  	Lint = Math.floor(Ldec); 
	  	L = (Ldec-Lint)*360;	
  		*/	
  		L = L*Math.PI/180;
	   
	  	// Formula L1 
	  	var L1 = 218.3164+481267.8812*t-0.001599*Math.pow(t,2);
  		/*	
  		L1dec = L1/360;
	  	L1int = Math.floor(L1dec); 
	  	L1 = (L1dec-L1int)*360;
  		*/	
  		L1 = L1*Math.PI/180;
	  
	  	//Formula M 
	  	var M = 357.5291+35999.0503*t-0.000154* Math.pow(t,2);
  		/*	
  		Mdec = M/360;
	  	Mint = Math.floor(Mdec); 
	  	M = (Mdec-Mint)*360;
  		*/	
  		M = M*Math.PI/180;
	  
	  	// Formula M1	
	  	var M1 = 134.9634+477198.8675*t+0.008721*Math.pow(t,2);
  		/*	
  		M1dec = M1/360;
	  	M1int = Math.floor(M1dec); 
	  	M1 = (M1dec-M1int)*360;
  		*/	
  		M1 = M1*Math.PI/180;
	  
	  	// Formula O 
	  	var O = 125.0443-1934.1363*t+0.002075*Math.pow(t,2);
  		/*	
  		Odec = O/360;
	  	Oint = Math.floor(Odec); 
	  	O = (Odec-Oint)*360;
  		*/	
  		O = O*Math.PI/180;
	  
	  	var DF = 	-(17.1996+0.01742*t)*Math.sin(O)
			  -(1.3187+0.00016*t)*Math.sin(2*L)
			  -0.2274*Math.sin(2*L1)
			  +0.2062*Math.sin(2*O)
			  +(0.1426-0.0004*t)*Math.sin(M)
			  +0.0712*Math.sin(M1)
			  -(0.0517-0.00012*t)*Math.sin(2*L+M)
			  -0.0386*Math.sin(2*L1-O)
			  -0.0301*Math.sin(2*L1+M1)
			  +0.0217*Math.sin(2*L-M)
			  -0.0158*Math.sin(2*L-2*L1+M1)
			  +0.0129*Math.sin(2*L-O)
			  +0.0123*Math.sin(2*L1-M1);
			  	  
	  	var DE = 	+(9.2025+0.00089*t)*Math.cos(O)
			  +(0.5736-0.00031*t)*Math.cos(2*L)
			  +0.0977*Math.cos(2*L1)
			  -0.0895*Math.cos(2*O)
			  +0.0224*Math.cos(2*L+M)
			  +0.0200*Math.cos(2*L1-O)
			  +0.0129*Math.cos(2*L1+M1)
			  -0.0095*Math.cos(2*L-M)
			  -0.0070*Math.cos(2*L-O);


		// Formula obliquità di Meeus
		// E0 = 23°26'21".448 - 46".8150*T - 0".00059T^2 +0".001813*T^3;
		var E0 = 23.4392911111 - 0.013004166666*t - 0.0000016388888*Math.pow(t,2) + 0.000000503611111*Math.pow(t,3);  
		var E10 = E0 + (DE/3600);
		
		
		if (E10 >= 360) 
			{
				var E11 = Math.floor(E10 / 360) * 360 ; 
				var E1 = E10 - E11;	
			}
						
		if (E10 <= -360)
			{
				var E11 = (Math.floor(E10 / 360)+1) * 360; 
				var E1 = (E10 - E11); 	
				if (E1 < 0) {E1 = E1 + 360}
			}
						
		if (E10 > -360 && E10 < 360)
			{
				if (E10 < 0) {var E1 = E10 + 360}
				var E1 = E10;	
			}



/*

	  // Formule di Berger
	    var E0 = 0;
		var E1 = berger()[0];

*/





			
		// conversione DF e DE in ore decimali 
		DF = DF / 3600;
		DE = DE / 3600;


		// Differenza in ascensione retta per la nutazione 
		var dra3 = (Math.cos(E1*Math.PI/180)+Math.sin(E1*Math.PI/180)*Math.sin(dra2*Math.PI/180)*Math.tan(ddec2*Math.PI/180))*DF - (Math.cos(dra2*Math.PI/180)*Math.tan(ddec2*Math.PI/180))*DE; 
		
		// Differenza in declinazione per la nutazione 
		var ddec3 = (Math.sin(E1*Math.PI/180)*Math.cos(dra2*Math.PI/180))*DF+Math.sin(dra2*Math.PI/180)*DE;  
		
		// longitudine media geometrica del sole 
		var LL = 280.46646 + 36000.76983 * t + 0.0003032 * Math.pow(t,2);
				
		// anomalia media geometrica del sole 
		var MM = 357.52911 + 35999.05029 * t - 0.0001537 * Math.pow(t,2);  
		
		// eccentricità dell'orbita terrestre 
		var ECC = 0.016708634 - 0.000042037 * t - 0.0000001267 * Math.pow(t,2);
		
		// equazione del centro del sole 
		var CC = (1.914602 - 0.004817 * t - 0.000014 * Math.pow(t,2))* Math.sin(MM*Math.PI/180)+(0.019993 - 0.000101 * t)* Math.sin((2*MM)*Math.PI/180)+0.000289 * Math.sin((3*MM)*Math.PI/180);
		
		// longitudine vera del sole 
		var LV = LL + CC;
		
		// longitudine del perielio 
		var PP = 102.93735 + 1.71946 * t + 0.00046 * Math.pow(t,2);
		
		var a2 = 20.49552 /3600 ; 
		
		
		// Differenza in ascensione retta per l'aberrazione annua della luce 
		var dra4 =  -a2 * ((Math.cos(dra2*Math.PI/180)*Math.cos(LV*Math.PI/180)*Math.cos(E1*Math.PI/180)+Math.sin(dra2*Math.PI/180)*Math.sin(LV*Math.PI/180))/Math.cos(ddec2*Math.PI/180))+ ECC * a2 *((Math.cos(dra2*Math.PI/180)*Math.cos(PP*Math.PI/180)*Math.cos(E1*Math.PI/180)+Math.sin(dra2*Math.PI/180)*Math.sin(PP*Math.PI/180))/Math.cos(ddec2*Math.PI/180));  
		
		
		// Differenza in declinazione per l'aberrazione annua della luce 
		var ddec4 =  -a2 * (  (Math.cos(LV*Math.PI/180)*Math.cos(E1*Math.PI/180)*(Math.tan(E1*Math.PI/180)*Math.cos(ddec2*Math.PI/180)-Math.sin(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180))+Math.cos(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180)*Math.sin(LV*Math.PI/180)))+ ECC * a2 * (  (Math.cos(PP*Math.PI/180)*Math.cos(E1*Math.PI/180)*(Math.tan(E1*Math.PI/180)*Math.cos(ddec2*Math.PI/180)-Math.sin(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180))+Math.cos(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180)*Math.sin(PP*Math.PI/180)));
		
				
		
		
		
		// ascensione retta in gradi sessagesimali decimali 
		var AR_G_DEC = dra2 + dra3 + dra4;
		
		// declinazione in gradi decimali 
		var DEC_G_DEC = ddec2 + ddec3 + ddec4; 
	
	
	
	
	
	obj.AR_1.value = AR_G_DEC; 
	obj.DEC_1.value = DEC_G_DEC; 
	
	

	
	
	
	
	
	
	
}
